 ; Ŀ
 ;   Raj - suck text into an underlying attribute.                         
 ;   Copyright 1994, 1995, 2005 by Rocket Software Ltd.                    
 ;   A program that rules.  (Pardon the mixed mythology.)                  
 ; 

 ; Ŀ
 ;   Midgard - find the midpoint of a text entity or attribute.            
 ;   Takes one argument: Enam, the entity ename.                           
 ;   Returns a point.                                                      
 ; 
 (DEFUN MIDGARD (enam / entt rota tblst cc dd bheigt bwidth llangg lldist ll
                                                                    ul lr ur)
  (setq entt (entget enam))
  (setq rota (cdr (assoc 50 entt)))
  (setq tblst (textbox entt))
  (setq cc (car tblst))                    ; ll offset from 10 of text
  (setq dd (cadr tblst))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 entt)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 (polar ll (angle ll ur) (/ (distance ll ur) 2)))
 ; Ŀ
 ;   Midgard end.                                                          
 ; 

 ; Ŀ
 ;   Pclose - find the attribute in a block whose midpoint is closest to   
 ;   that of a text entity.                                                
 ;   Arguments: Pa, the entity midpoint.                                   
 ;              Plist, the list of attribute midpoints and enames.         
 ;   Returns an attribute ename.                                           
 ; 
 (DEFUN PCLOSE (pa plist / num sub distc mindis mini)
  (setq num 0)
  (while (setq sub (nth num plist))
         (setq num (1+ num))
         (setq distc (distance pa (car sub)))
         (if (or (null mindis) (< distc mindis))
             (progn
                  (setq mindis distc)
                  (setq mini sub))))
 (cadr mini))
 ; Ŀ
 ;   Pclose end.                                                           
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Raj.                                                                  
 ; 
 (DEFUN C:RAJ (/ ss esav enam entt pa malist num str atnam)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get a selection set.                                                  
 ;   For more general use one could find the block for each text entity,   
 ;   this way is faster and simpler.                                       
 ; 
  (prompt "\nSelect text to suck into a block.")
  (cond ((null (setq ss (ssget '((0 . "text"))))))
        ((null (setq esav (setq enam (car (entsel "\nBlock: "))))))
        ((null (assoc 66 (entget enam)))
         (prompt "\nThat block does not have attributes."))
        (T
 ; Ŀ
 ;   Reduce the block to a list: ((midpoint attribute_ename) ...).         
 ; 
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                             (setq enam (entnext enam)))))))
 ;              (setq pa (midgard enam))
                (setq pa (spit (entget enam)))
                (setq malist (cons (list pa enam) malist)))
 ; Ŀ
 ;   Step through the selection set.                                       
 ; 
         (setq num 0)
         (while (setq enam (ssname ss num))
                (setq num (1+ num))
                (setq entt (entget enam))
 ; Ŀ
 ;   Get the string, find the midpoint, erase the entity.                  
 ; 
                (setq str (cdr (assoc 1 entt)))
 ;              (setq pa (midgard enam))
                (setq pa (spit (entget enam)))
                (entdel enam)
 ; Ŀ
 ;   Now find the underlying block and locate the attribute whose          
 ;   physical midpoint is closest to the midpoint of the text.             
 ; 
                (setq atnam (pclose pa malist))         
                (setq entt (entget atnam))
                (entmod (subst (cons 1 str) (assoc 1 entt) entt)))
 ; Ŀ
 ;   Update the block.                                                     
 ; 
         (entupd esav)))
 (princ))